/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import java.util.OptionalInt;
import java.util.function.Function;
import org.openzen.zencode.java.logger.ScriptingEngineLogger;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.validator.ValidationLogEntry;

final class ScriptRunLogger
implements ScriptingEngineLogger {
    private final Function<SourceFile, OptionalInt> priority;

    ScriptRunLogger(Function<SourceFile, OptionalInt> priorityGetter) {
        this.priority = priorityGetter;
    }

    @Override
    public void logCompileException(CompileException exception) {
        CraftTweakerAPI.LOGGER.error("Error while compiling scripts: ", (Throwable)exception);
    }

    @Override
    public void info(String message) {
        CraftTweakerAPI.LOGGER.info(message);
    }

    @Override
    public void debug(String message) {
        CraftTweakerAPI.LOGGER.debug(message);
    }

    @Override
    public void trace(String message) {
        CraftTweakerAPI.LOGGER.trace(message);
    }

    @Override
    public void warning(String message) {
        CraftTweakerAPI.LOGGER.warn(message);
    }

    @Override
    public void error(String message) {
        CraftTweakerAPI.LOGGER.error(message);
    }

    @Override
    public void throwingErr(String message, Throwable throwable) {
        CraftTweakerAPI.LOGGER.error("Error while running scripts:", throwable);
    }

    @Override
    public void throwingWarn(String message, Throwable throwable) {
        CraftTweakerAPI.LOGGER.warn("Warning while running scripts:", throwable);
    }

    @Override
    public void logSourceFile(SourceFile file) {
        CraftTweakerAPI.LOGGER.info("Loading file '{}'{}", (Object)file.getFilename(), (Object)this.priority.apply(file).stream().mapToObj(it -> " with priority " + it).findFirst().orElse(""));
    }

    @Override
    public void logValidationError(ValidationLogEntry errorEntry) {
        CraftTweakerAPI.LOGGER.error("{}: {}", (Object)errorEntry.position, (Object)errorEntry.message);
    }

    @Override
    public void logValidationWarning(ValidationLogEntry warningEntry) {
        CraftTweakerAPI.LOGGER.warn("{}: {}", (Object)warningEntry.position, (Object)warningEntry.message);
    }
}

